<?php

namespace App\Http\Controllers;

use toastr;
use App\Models\Product;
use App\Models\Category;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        //get products
        $products = Product::orderBy("created_at", "DESC")->paginate(9);
        /**
         * get a single menu rand
         */
        $menu = Category::inRandomOrder()->first();
        $menu_products = Product::where( "category_id", $menu->id)->orderBy("created_at", "DESC")->get();
        return view('home')->with(["products" => $products, "menu_name" => $menu->name, "menu_products" => $menu_products]);
    }
}
