@extends('layouts.app')
@section("title", "Register")
@section('content')


<div id="wrapper">
       
      @include('layouts.includes.main-header')

    <!-- Content
    ============================================= -->
    <div id="content">

    @include('layouts.includes.main-nav')
    <!-- Our Register
    ============================================= -->
    <section class="padding-100 login">
        <div class="container">
          <div class="row">
            <div class="col-md-4 col-md-offset-4 col-sm-6 col-sm-offset-3">
                <div class="text-center">
                    <i class="icon-intro"></i>
                    <h1>Register</h1>
                    <span class="welcome ">Register to continue</span>
                </div>
                    <div class="form-group padding-50">
                        @if (Session::has('error'))
                            <div class="alert alert-danger">{{ Session::get('error') }}</div>
                        @endif
                        <form class="register-form" method="POST" action="{{ route("register") }}">
                            @csrf
                            <div class="form-group">
                                <label for="first_name">First Name</label>
                                <input type="text" class="form-control @error('first_name') border border-danger @enderror" name="first_name" value="{{ old('first_name') }}">
                                @error('first_name')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label for="last_name">Last Name</label>
                                <input type="text" class="form-control @error('last_name') border border-danger @enderror" name="last_name" value="{{ old('last_name') }}">
                                @error('last_name')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label for="email">Email Address</label>
                                <input type="email" class="form-control @error('email') border border-danger @enderror" name="email" value="{{ old('email') }}">
                                @error('email')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label for="address">Address</label>
                                <input type="text" class="form-control @error('address') border border-danger @enderror" name="address" value="{{ old('address') }}">
                                @error('address')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label for="tel">Phone Number</label>
                                <input type="tel" class="form-control @error('tel') border border-danger @enderror" name="tel" value="{{ old('tel') }}">
                                @error('tel')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label for="password">Password</label>
                                <input type="password" class="form-control @error('password') border border-danger @enderror" name="password">
                                @error('password')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label for="password_confirmation">Confirm Password</label>
                                <input type="password" class="form-control" name="password_confirmation">
                            </div>
                        <button type="submit" class="btn form-control btn-black">Register</button>
                        </form>
                    </div>
                    <div class="forget text-center">
                        <p>Already have an account? <a href="{{ route("login") }}">Login <i class="fa fa-chevron-circle-right"></i></a></p>
                    </div>
            </div>
          </div>
        </div>
      </section>
      <!-- End Register -->
    </div>
    <!-- end of #content -->
</div>
@endsection
