<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CartController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\DeliveryController;
use App\Http\Controllers\DashboardController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

//Route::get("/", [App\Http\Controllers\AdminController::class, 'index'])->name("admin");

Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::post('/guest-user.store', [CheckoutController::class, 'storeGuest'])->name('guest-user.store');
//product
//Cart
Route::get('/cart', [CartController::class, 'index'])->name("cart");

//Menu
Route::get("/menu",  [MenuController::class, 'index'])->name("menu");

//Contact
Route::get("/contact", [ContactController::class, 'index'])->name("contact");
Route::post("/contact", [ContactController::class, 'sendMessage']);

//cart
Route::get("/cart", [CartController::class, 'index'])->name('cart');
Route::get('add-to-cart/{id}', [CartController::class, 'addToCart'])->name("addToCart");
Route::patch('sub-qty/{id}',  [CartController::class, 'subQty'])->name('update-cart');
Route::get('remove-from-cart/{id}',  [CartController::class, 'fromItem'])->name('remove-item');

//checkout
Route::get('/checkout',[CheckoutController::class, 'index'])->name("checkout");
Route::post('/checkout', [CheckoutController::class, 'checkout'])->name('del.checkout');
Route::get('/payment', [CheckoutController::class, 'payment'])->name('payment');

//payment
Route::post('/pay', [PaymentController::class ,'redirectToGateway'])->name('pay');
Route::get('/payment/callback', [PaymentController::class, 'handleGatewayCallback']);
Route::webhooks('/paystack/webhook');

Route::get('/payment/success', [PaymentController::class, 'paymentSuccess'])->name('notifications.payment_success');
Route::get('/payment/failed', [PaymentController::class, 'paymentFailed'])->name('notifications.payment_failed');

Route::get('search', [SearchController::class, 'index'])->name('search');


Route::group(['middleware' => 'auth'], function(){
    //Customer
   Route::get("/dashboard", [DashboardController::class, 'index'])->name("dashboard");
  
    Route::post("/updateAccount", [DashboardController::class, 'updateAccount'])->name("update.account");
    Route::post("/change-password", [DashboardController::class, 'changePassword'])->name('change.password');
    //Admin
    Route::get("/admin", [AdminController::class, 'index'])->name("admin");

    //category
    Route::get('/admin/category', [CategoryController::class, 'index'])->name("category");
    Route::post('/admin/category', [CategoryController::class, 'store']);
    Route::get('/admin/edit-category/{id}', [CategoryController::class, 'editModal'])->name('edit-category');
    Route::get('/admin/delete-category/{id}', [CategoryController::class, 'deleteModal']);
    Route::post('/admin/update-category', [CategoryController::class, 'update'])->name("update.category");
    Route::post('/admin/delete-category', [CategoryController::class, 'delete'])->name("delete.category");

    //product
    Route::get("/admin/add-product", [ProductController::class, 'index'])->name("add.product");
    Route::get("/admin/manage-product", [ProductController::class, 'manage'])->name("manage.product");
    Route::get("/admin/edit-product/{id}", [ProductController::class, 'edit'])->name("edit.product");

    Route::post("/admin/add-product", [ProductController::class, 'store']);
    Route::post('/admin/edit-product', [ProductController::class, 'update'])->name("update.product");
    Route::get('/admin/delete-product/{id}', [ProductController::class, 'deleteModal']);
    Route::post('/admin/delete-product', [ProductController::class, 'delete'])->name("delete.product");

    //people
    Route::get("/admin/people/profile", [AdminController::class, 'profile'])->name("people.profile");
    Route::get("/admin/people/customers", [AdminController::class, 'customers'])->name("people.customers");
    Route::get('/admin/delete-customer/{id}', [AdminController::class, 'deleteModal']);
    Route::post('/admin/delete-customer', [AdminController::class, 'delete'])->name("delete.customer");

    //payment
    Route::get("/admin/payments", [AdminController::class, "payments"])->name("admin.payments");

    //Delivery
    Route::get("/admin/add-delivery", [DeliveryController::class, 'index'])->name("add.delivery");
    Route::get("/admin/manage-delivery",[DeliveryController::class, 'manage'])->name("manage.delivery");

    //Sales
    Route::get("/admin/manage-sales", [OrderController::class, 'manage'])->name("manage.sales");
    Route::get("/admin/delete-order/{id}", [OrderController::class, "deleteModal"]);
    Route::post("/admin/delete-order", [OrderController::class, "delete"])->name("delete.order");
    Route::get("/admin/view-order/{id}", [OrderController::class, "viewModal"]);

});
