
<!DOCTYPE html>
<html lang="en">


<head>
        <meta charset="utf-8" />
        <title><?php echo $__env->yieldContent("title"); ?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
        <meta content="" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />

        <!-- App favicon -->
        <link rel="shortcut icon" href="<?php echo e(asset("img/logo/logo_white.png")); ?>">

        <link href="<?php echo e(asset("plugins/leaflet/leaflet.css")); ?>" rel="stylesheet">
        <link href="<?php echo e(asset("plugins/lightpick/lightpick.css")); ?>" rel="stylesheet" />

        <!-- DataTables -->
        <link href="<?php echo e(asset("plugins/datatables/dataTables.bootstrap4.min.css")); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset("plugins/datatables/buttons.bootstrap4.min.css")); ?>" rel="stylesheet" type="text/css" />
        <!-- Responsive datatable examples -->
        <link href="<?php echo e(asset("plugins/datatables/responsive.bootstrap4.min.css")); ?>" rel="stylesheet" type="text/css" />

        <!-- App css -->
        <link href="<?php echo e(asset("css/bootstrap.min.css")); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset("css/icons.min.css")); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset("css/metisMenu.min.css")); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset("plugins/daterangepicker/daterangepicker.css")); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset("css/app.min.css")); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset("css/reset2.css")); ?>" rel="stylesheet" type="text/css" />

    </head>

    <body class="dark-sidenav">
        <!-- Left Sidenav -->
        <div class="left-sidenav">
            <!-- LOGO -->
            <div class="brand">
                <a href="<?php echo e(route("home")); ?>" class="logo">
                    <span>
                        <img src="<?php echo e(asset("img/logo/logo_white.png")); ?>" alt="logo-small" class="logo-sm">
                    </span>
                </a>
            </div>
            <!--end logo-->
            <div class="menu-content h-100" data-simplebar>
                <ul class="metismenu left-sidenav-menu">
                    <li class="menu-label mt-0">Main</li>
                    <li>
                        <a href="<?php echo e(route('admin')); ?>"> <i data-feather="home" class="align-self-center menu-icon"></i><span>Dashboard</span><span class="menu-arrow"></span></a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('category')); ?>"><i data-feather="grid" class="align-self-center menu-icon"></i><span>Menu Group</span><span class="menu-arrow"></span></a>
                    </li>

                    <li>
                        <a href="javascript: void(0);"><i data-feather="layers" class="align-self-center menu-icon"></i><span>Menu Item</span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
                        <ul class="nav-second-level" aria-expanded="false">
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route("add.product")); ?>"><i class="ti-control-record"></i>Add item</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route("manage.product")); ?>"><i class="ti-control-record"></i>Manage items</a></li>
                        </ul>
                    </li>

                    <li>
                        <a href="<?php echo e(route("manage.sales")); ?>"><i data-feather="layout" class="align-self-center menu-icon"></i><span>Orders</span></a>
                    </li>
                    
                    <li>
                        <a href="<?php echo e(route("admin.payments")); ?>"><i data-feather="dollar-sign" class="align-self-center menu-icon"></i><span>Payments</span><span class="menu-arrow"></span></a>
                    </li>
                    <li>
                        <a href="javascript: void(0);"><i data-feather="users" class="align-self-center menu-icon"></i><span>People</span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
                        <ul class="nav-second-level" aria-expanded="false">
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route("people.customers")); ?>"><i class="ti-control-record"></i>Customers</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route("people.profile")); ?>"><i class="ti-control-record"></i>Profile</a></li>
                        </ul>
                    </li>
                </ul>

            </div>
        </div>
        <!-- end left-sidenav-->


        <div class="page-wrapper">
            <!-- Top Bar Start -->
            <div class="topbar">
                <!-- Navbar -->
                <nav class="navbar-custom">
                    <ul class="list-unstyled topbar-nav float-right mb-0">
                        <li class="dropdown hide-phone">
                            <a class="nav-link dropdown-toggle arrow-none waves-light waves-effect" data-toggle="dropdown" href="#" role="button"
                                aria-haspopup="false" aria-expanded="false">
                                <i data-feather="search" class="topbar-icon"></i>
                            </a>

                            <div class="dropdown-menu dropdown-menu-right dropdown-lg p-0">
                                <!-- Top Search Bar -->
                                <div class="app-search-topbar">
                                    <form action="#" method="get">
                                        <input type="search" name="search" class="from-control top-search mb-0" placeholder="Type text...">
                                        <button type="submit"><i class="ti-search"></i></button>
                                    </form>
                                </div>
                            </div>
                        </li>



                        <li class="dropdown">
                            <a class="nav-link dropdown-toggle waves-effect waves-light nav-user" data-toggle="dropdown" href="#" role="button"
                                aria-haspopup="false" aria-expanded="false">
                                <span class="ml-1 nav-user-name hidden-sm"><?php echo e(Auth()->user()->first_name . ' ' . Auth()->user()->last_name); ?></span>
                                <img src="<?php echo e(asset("images/users/avatar.svg")); ?>" alt="<?php echo e(Auth()->user()->first_name . ' ' . Auth()->user()->last_name); ?>" class="rounded-circle thumb-xs" />
                            </a>
                            <div class="dropdown-menu dropdown-menu-right">
                                <a class="dropdown-item" href="#"><i data-feather="user" class="align-self-center icon-xs icon-dual mr-1"></i> Profile</a>
                                <div class="dropdown-divider mb-0"></div>
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                document.getElementById('logout-form').submit();"><i data-feather="power" class="align-self-center icon-xs icon-dual mr-1"></i> Logout</a>
                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </li>
                    </ul><!--end topbar-nav-->

                    <ul class="list-unstyled topbar-nav mb-0">
                        <li>
                            <button class="nav-link button-menu-mobile">
                                <i data-feather="menu" class="align-self-center topbar-icon"></i>
                            </button>
                        </li>

                    </ul>
                </nav>
                <!-- end navbar-->
            </div>
            <!-- Top Bar End -->

            <!-- Page Content-->
            <div class="page-content">

                <?php echo $__env->yieldContent("content"); ?>
                <footer class="footer text-center text-sm-left">
                    &copy; <?php echo date('Y') ?> All Right Reserved <span class="d-none d-sm-inline-block float-right">Powered <i class="mdi mdi-heart text-danger"></i> by Jubilee Systems Limited</span>
                </footer><!--end footer-->
            </div>
            <!-- end page content -->
        </div>
        <!-- end page-wrapper -->




        <!-- jQuery  -->
        <script src="<?php echo e(asset("js/jquery.min.js")); ?>"></script>
        <script src="<?php echo e(asset("js/bootstrap.bundle.min.js")); ?>"></script>
        <script src="<?php echo e(asset("js/metismenu.min.js")); ?>"></script>
        <script src="<?php echo e(asset("js/waves.js")); ?>"></script>
        <script src="<?php echo e(asset("js/feather.min.js")); ?>"></script>
        <script src="<?php echo e(asset("js/simplebar.min.js")); ?>"></script>
        <script src="<?php echo e(asset("js/moment.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/daterangepicker/daterangepicker.js")); ?>"></script>

        <script src="<?php echo e(asset("plugins/leaflet/leaflet.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/lightpick/lightpick.js")); ?>"></script>
        <script src="<?php echo e(asset("pages/jquery.profile.init.js")); ?>"></script>



        <!-- Required datatable js -->
        <script src="<?php echo e(asset("plugins/datatables/jquery.dataTables.min.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/datatables/dataTables.bootstrap4.min.js")); ?>"></script>
        <!-- Buttons examples -->
        <script src="<?php echo e(asset("plugins/datatables/dataTables.buttons.min.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/datatables/buttons.bootstrap4.min.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/datatables/jszip.min.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/datatables/pdfmake.min.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/datatables/vfs_fonts.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/datatables/buttons.html5.min.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/datatables/buttons.print.min.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/datatables/buttons.colVis.min.js")); ?>"></script>
        <!-- Responsive examples -->
        <script src="<?php echo e(asset("plugins/datatables/dataTables.responsive.min.js")); ?>"></script>
        <script src="<?php echo e(asset("plugins/datatables/responsive.bootstrap4.min.js")); ?>"></script>
        <script src="<?php echo e(asset("pages/jquery.datatable.init.js")); ?>"></script>

        <!-- App js -->
        <script src="<?php echo e(asset("js/app.js")); ?>"></script>

    </body>


</html>
<?php /**PATH /home/landnkitchen/public_html/core/resources/views/layouts/admin.blade.php ENDPATH**/ ?>