<?php $__env->startSection("title", "Payments"); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page-Title -->
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <div class="row">
                    <div class="col">
                        <h4 class="page-title">Payments</h4>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Landnkitchen</a></li>
                            <li class="breadcrumb-item active">Payments</li>
                        </ol>
                    </div><!--end col-->
                </div><!--end row-->
            </div><!--end page-title-box-->
        </div><!--end col-->
    </div><!--end row-->
    <!-- end page title end breadcrumb -->
    <div class="row">
        <div class="col-12">
            <?php if(Session::has('error')): ?>
                <div class="alert alert-danger" role="alert">
                    <?php echo e(Session::get('error')); ?>

                </div>
            <?php endif; ?>
            <?php if(Session::has('success')): ?>
                <div class="alert alert-success" role="alert">
                    <?php echo e(Session::get('success')); ?>

                </div>
            <?php endif; ?>
            <div class="table-responsive">
                <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                    <tr>
                        <th>SN</th>
                        <th>OrderId</th>
                        <th>Reference</th>
                        <th>Name</th>
                        <th>Price</th>
                        <th>Status</th>
                        <th>Date</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php $sn = 1 ?>
                        <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td><?php echo e($sn); ?></td>
                            <td><?php echo e($row->order_id); ?></td>
                            <td><?php echo e($row->reference); ?></td>
                            <td><?php echo e($row->fullname); ?></td>
                            <td>&#8358; <?php echo e(number_format($row->amount, 2)); ?></td>
                            <td><?php echo e($row->status); ?></td>
                            <td><?php echo e($row->created_at->diffForHumans()); ?></td>
                        </tr>
                        <?php $sn ++ ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

</div><!-- container -->


<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jubilees/trendsadmin.jubileesystem.com/core/resources/views/admin/payments.blade.php ENDPATH**/ ?>