<!DOCTYPE html>
    <html lang="en">
    <head>
    <!-- Meta Tags
        ============================================= -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Majesty by creative-wp - Responsive HTML5 template">
    <meta name="author" content="creative-wp">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <!-- Your Title Page
        ============================================= -->
    <title><?php echo $__env->yieldContent("title"); ?></title>
    <!-- Favicon Icons
        ============================================= -->
    <link rel="shortcut icon" href="img/favicon.ico">
    <!-- Bootstrap Links
        ============================================= -->
    <!-- Latest compiled and minified CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">

    <!-- Plugins
        ============================================= -->
    <!-- Owl Carousal -->
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/owl.carousel.css")); ?>">
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/owl.theme.css")); ?>">
    <!-- Animate -->
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/animate.css")); ?>">
    <!-- Date Picker -->
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/jquery.datetimepicker.css")); ?>">
    <!-- Pretty Photo -->
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/prettyPhoto.css")); ?>">
    <!-- Font awsome icons -->
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/font-awesome.min.css")); ?>">
    <!-- General Stylesheet
        ============================================= -->
    <!-- Custom Fonts Setup via Font-face CSS3 -->
    <link href="<?php echo e(asset("fonts/fonts.css")); ?>" rel="stylesheet">
    <!-- Main Template Styles -->
    <link href="<?php echo e(asset("stylesheets/main.css")); ?>" rel="stylesheet">
    <!-- Main Template Responsive Styles -->
    <?php echo toastr_css(); ?>
    <link href="<?php echo e(asset("stylesheets/main-responsive.css")); ?>" rel="stylesheet">
    <link href="<?php echo e(asset("css/reset.css")); ?>" rel="stylesheet">
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_GB/sdk.js#xfbml=1&version=v12.0&appId=609343699728641&autoLogAppEvents=1" nonce="6qPCXhlo"></script>
</head>
<body>


    <?php echo $__env->yieldContent('content'); ?>
  <!-- Footer
    ============================================= -->
 
    <!-- End container -->
    <!-- Footer logo !-->
    <div class="footer_logo text-center"> <img  src="<?php echo e(asset("img/logo/logo_white.png")); ?>"  alt="logo" style="width:70px;height:70px;">
      <p> <?php date('Y') ?> ALL RIGHT RESERVED. DESIGNED BY <a target="_blank" href="https://www.jubileesys.com">Jubilee System Ltd</a></p>
    </div>
    <!-- End Footer logo !-->
  </footer>
  <!-- End footer -->
  <!--  scroll to top of the page-->
  <a href="#" id="scroll_up" ><i class="fa fa-angle-up"></i></a> </div>
    <!-- End wrapper -->
    <!-- Core JS Libraries -->
    <script src="<?php echo e(asset("javascripts/libs/jquery.min.js")); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset("javascripts/libs/plugins.js")); ?>"></script>
    <?php echo toastr_js(); ?>
    <!-- Latest compiled and minified JavaScript -->
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>
    <script src="<?php echo e(asset("javascripts/libs/modernizr.js")); ?>"></script>
    <!-- JS Custom Codes -->
    <script src="<?php echo e(asset("javascripts/custom/main.js")); ?>" ></script>
    <script src="<?php echo e(asset("javascripts/custom/script.js")); ?>" ></script>

<script>

toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": true,
  "positionClass": "toast-top-right",
  "preventDuplicates": true,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
}

function refreshPage() {
    location.reload(true);
}
    const BASE_URL = "<?php echo e(url('/')); ?>";
    const REQUEST_URL = "<?=Request::url()?>";
    let CSRF = "<?php echo e(csrf_token()); ?>";
    $('.addToCart').on("click", function(e){
        var id = $(this).attr("data-id");
        var data = new FormData();
        data.append('id', id);

        $.ajax({
            url: BASE_URL + '/add-to-cart/'+ id,
            type: "GET",
            timeout: 5000,
            data: data,
            contentType: false,
            cache: false,
            processData: false,
            headers: {'X-CSRF-TOKEN': CSRF},
            success: function(response){
                toastr.success('Added to cart');
                refreshPage();
            },
        error: function(e){
            alert("Oops, there was an error, try again later");
        }
    });
    });
</script>
</body>
</html>
<?php /**PATH /home/jubilees/trends.jubileesystem.com/core/resources/views/layouts/app.blade.php ENDPATH**/ ?>