<!DOCTYPE html>
    <html lang="en">
    <head>
    <!-- Meta Tags
        ============================================= -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Majesty by creative-wp - Responsive HTML5 template">
    <meta name="author" content="creative-wp">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <!-- Your Title Page
        ============================================= -->
    <title><?php echo $__env->yieldContent("title"); ?></title>
    <!-- Favicon Icons
        ============================================= -->
    <link rel="shortcut icon" href="img/favicon.ico">
    <!-- Bootstrap Links
        ============================================= -->
    <!-- Latest compiled and minified CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">

    <!-- Plugins
        ============================================= -->
    <!-- Owl Carousal -->
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/owl.carousel.css")); ?>">
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/owl.theme.css")); ?>">
    <!-- Animate -->
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/animate.css")); ?>">
    <!-- Date Picker -->
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/jquery.datetimepicker.css")); ?>">
    <!-- Pretty Photo -->
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/prettyPhoto.css")); ?>">
    <!-- Font awsome icons -->
    <link rel="stylesheet" href="<?php echo e(asset("stylesheets/font-awesome.min.css")); ?>">
    <!-- General Stylesheet
        ============================================= -->
    <!-- Custom Fonts Setup via Font-face CSS3 -->
    <link href="<?php echo e(asset("fonts/fonts.css")); ?>" rel="stylesheet">
    <!-- Main Template Styles -->
    <link href="<?php echo e(asset("stylesheets/main.css")); ?>" rel="stylesheet">
    <!-- Main Template Responsive Styles -->
    <?php echo toastr_css(); ?>
    <link href="<?php echo e(asset("stylesheets/main-responsive.css")); ?>" rel="stylesheet">
    <link href="<?php echo e(asset("css/reset.css")); ?>" rel="stylesheet">
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_GB/sdk.js#xfbml=1&version=v12.0&appId=609343699728641&autoLogAppEvents=1" nonce="6qPCXhlo"></script>
</head>
<body>


    <?php echo $__env->yieldContent('content'); ?>
  <!-- Footer
    ============================================= -->
  <footer id="footer" class="padding-50 dark">
    <div class="container">
      <div class="row">
        <!-- Our location !-->
        <div class="col-md-4 col-sm-6 col-xs-12 our_location">
          <h3>Our Location</h3>

          <h5>Wuse II Outlet:</h5>
          <p>Address:</p>
          <span>No 49b Kumasi Crescent, Wuse II, (Behind Dominos Pizza) Abuja</span>
          <p class="mt10">Phone <a href="tel:+2347044854619"><span> 0704 485 4619</span></a></p>


          <h5>Gwarinpa Outlet:</h5>
          <p>Address:</p>
          <span>Shop A2 Primus Mall, (Beside Total Filling Station) Gwarinpa Estate, Abuja</span>
          <p class="mt10">Phone <a href="tel:+2348143177743"><span> 0814 317 7743 </span></a></p>
          <p class="mt30">E-mail: <a href="mailto:landnkitchen@gmail.com"><span>landnkitchen@gmail.com</span></a>, <a href="mailto:support@landnkitchen.com.ng"><span>support@landnkitchen.com.ng</span> </a> </p>

          <ul class="social mt30">
            <li><a href="https://www.facebook.com/landnkitchen/" target="_blank" data-toggle="tooltip" title="Facebook"><i class="fa fa-facebook"></i></a></li>
            <li><a href="https://www.instagram.com/landnkitchen/" target="_blank" data-toggle="tooltip" title="Instagram"><i class="fa fa-instagram"></i></a></li>
            <li><a href="https://twitter.com/landnkitchen" target="_blank" data-toggle="tooltip" title="Twitter+"><i class="fa fa-twitter"></i></a></li>
          </ul>
        </div>
        <!-- End our location -->
        <!-- Opening time !-->
        <div class="col-md-4 col-sm-6 col-xs-12 opening_time">
          <h3>Opening Times</h3>
          <ul>
            <li>
              <p>Wuse II Hours
                <time datetime="00:01"> 8 am - 11 pm </time>
              </p>
            </li>
            <li>
                <p>Gwarinpa Hours
                  <time datetime="00:01"> 8 am - 8 pm </time>
                </p>
              </li>
          </ul>
          <h5>Payment method</h5>
          <img src="<?php echo e(asset("img/paystack.png")); ?>" alt="" style="width: 250px;">
          <p><em>Cash payments (exclusive to pickups & dine-in options)</em></p>
        </div>
        <div class="col-md-4 col-sm-6 col-xs-12">
            <div class="fb-page" data-href="https://www.facebook.com/landnkitchen/" data-tabs="timeline" data-width="500" data-height="" data-small-header="true" data-adapt-container-width="true" data-hide-cover="false" data-show-facepile="true"><blockquote cite="https://www.facebook.com/landnkitchen/" class="fb-xfbml-parse-ignore"><a href="https://www.facebook.com/landnkitchen/">L and N kitchen</a></blockquote></div>
        </div>
      </div>
    </div>
    <!-- End container -->
    <!-- Footer logo !-->
    <div class="footer_logo text-center"> <img  src="<?php echo e(asset("img/logo/logo_white.png")); ?>"  alt="logo" style="width:70px;height:70px;">
      <p> <?php date('Y') ?> ALL RIGHT RESERVED. DESIGNED BY <a target="_blank" href="https://www.jubileesys.com">Jubilee System Ltd</a></p>
    </div>
    <!-- End Footer logo !-->
  </footer>
  <!-- End footer -->
  <!--  scroll to top of the page-->
  <a href="#" id="scroll_up" ><i class="fa fa-angle-up"></i></a> </div>
    <!-- End wrapper -->
    <!-- Core JS Libraries -->
    <script src="<?php echo e(asset("javascripts/libs/jquery.min.js")); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset("javascripts/libs/plugins.js")); ?>"></script>
    <?php echo toastr_js(); ?>
    <!-- Latest compiled and minified JavaScript -->
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>
    <script src="<?php echo e(asset("javascripts/libs/modernizr.js")); ?>"></script>
    <!-- JS Custom Codes -->
    <script src="<?php echo e(asset("javascripts/custom/main.js")); ?>" ></script>
    <script src="<?php echo e(asset("javascripts/custom/script.js")); ?>" ></script>

<script>

toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": true,
  "positionClass": "toast-top-right",
  "preventDuplicates": true,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
}

function refreshPage() {
    location.reload(true);
}
    const BASE_URL = "<?php echo e(url('/')); ?>";
    const REQUEST_URL = "<?=Request::url()?>";
    let CSRF = "<?php echo e(csrf_token()); ?>";
    $('.addToCart').on("click", function(e){
        var id = $(this).attr("data-id");
        var data = new FormData();
        data.append('id', id);

        $.ajax({
            url: BASE_URL + '/add-to-cart/'+ id,
            type: "GET",
            timeout: 5000,
            data: data,
            contentType: false,
            cache: false,
            processData: false,
            headers: {'X-CSRF-TOKEN': CSRF},
            success: function(response){
                toastr.success('Added to cart');
                refreshPage();
            },
        error: function(e){
            alert("Oops, there was an error, try again later");
        }
    });
    });
</script>
</body>
</html>
<?php /**PATH /home2/landnkitchen/public_html/core/resources/views/layouts/app.blade.php ENDPATH**/ ?>